<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('candidate_search', function (Blueprint $table) {
            $table->id('Profile_id')->unsigned()->autoIncrement();
            $table->bigInteger('User_id')->unsigned();
            $table->string('First_name', 100);
            $table->string('Last_name', 100);
            $table->json('Skills')->nullable();
            $table->json('Certifications')->nullable();
            $table->string('Location', 255)->nullable();
            $table->integer('Experience')->nullable()->comment('Experience in years');
            $table->timestamps();

            $table->foreign('User_id')->references('User_id')->on('users')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('candidate_search');
    }
};
